﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Windows.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_NativeHandleTypes.h>

#include "os_Diag.h"
#include "os_Common.h"

namespace nn { namespace os { namespace detail {

//--------------------------------------------------------------------------
//  NativeHandleImplByWin32 クラス
//

class   NativeHandleImplByWin32
{
public:
    // メンバ関数
    static void Close(NativeHandle) NN_NOEXCEPT;
};

typedef NativeHandleImplByWin32     NativeHandleImpl;

//--------------------------------------------------------------------------

inline void NativeHandleImplByWin32::Close(NativeHandle handle) NN_NOEXCEPT
{
    BOOL ret = ::CloseHandle( handle );
    NN_SDK_ASSERT( ret != 0, "Cannot close the Win32 handle.");
    NN_UNUSED(ret);
}

//--------------------------------------------------------------------------

}}} // namespace nn::os::detail


