﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>

namespace nn { namespace os {
namespace detail {

// ロック履歴を検査し、足跡を残す
void    PushAndCheckLockLevel(MutexType* mutex) NN_NOEXCEPT;

// ロック履歴を検査し、足跡を消す
void    PopAndCheckLockLevel(MutexType* mutex) NN_NOEXCEPT;

#if defined(NN_SDK_BUILD_RELEASE)
inline void    PushAndCheckLockLevel(MutexType* mutex) NN_NOEXCEPT
{
    NN_UNUSED( mutex );
}

inline void    PopAndCheckLockLevel(MutexType* mutex) NN_NOEXCEPT
{
    NN_UNUSED( mutex );
}
#endif

}   // namespace detail
}}  // namespace nn::os
