﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#if defined(NN_BUILD_CONFIG_COMPILER_GCC)
    // Windowsを含め全てのOS種別で共通
    #include "os_MemoryBarrier-compiler.gcc.h"
#elif defined(NN_BUILD_CONFIG_OS_WIN32)
    #include "os_MemoryBarrier-os.win32.h"
#else
    #error   "サポートされている OS または コンパイラ種別が指定されていません。"
#endif


//--------------------------------------------------------------------------
//  C++ 向けのプロトタイプ宣言
//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

}   // namespace detail
}}  // namespace nn::os

