﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_LightEventTypes.h>

#define NN_OS_REQUIRES_INITIALIZED(p) \
        NN_SDK_REQUIRES( (p)->_signalState != LightEventType::NotInitialized, NN_TEXT_OS("nn::os::%s(): 指定された LightEvent が初期化されていません。"), NN_CURRENT_FUNCTION_NAME)

namespace nn { namespace os { namespace detail {

void InitializeLightEventImpl(LightEventType* event, bool initiallySignaled, EventClearMode clearMode) NN_NOEXCEPT;
void FinalizeLightEventImpl(LightEventType* event) NN_NOEXCEPT;
void SignalLightEventImpl(LightEventType* event) NN_NOEXCEPT;
void ClearLightEventImpl(LightEventType* event) NN_NOEXCEPT;
void WaitLightEventImpl(LightEventType* event) NN_NOEXCEPT;
bool TryWaitLightEventImpl(LightEventType* event) NN_NOEXCEPT;
bool TimedWaitLightEventImpl(LightEventType* event, TimeSpan timeout) NN_NOEXCEPT;

}}} // namespace nn::os::detail

