﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Result.h>
#include <nn/os/os_EventCommon.h>
#include <nn/os/os_SystemEventTypes.h>

namespace nn { namespace os { namespace detail {

//-----------------------------------------------------------------------------

Result CreateInterProcessEvent(InterProcessEventType*, EventClearMode) NN_NOEXCEPT;
void   DestroyInterProcessEvent(InterProcessEventType*) NN_NOEXCEPT;

void   AttachInterProcessEvent(InterProcessEventType*, NativeHandle, bool, NativeHandle, bool, EventClearMode) NN_NOEXCEPT;
NativeHandle DetachReadableHandleOfInterProcessEvent(InterProcessEventType*) NN_NOEXCEPT;
NativeHandle DetachWritableHandleOfInterProcessEvent(InterProcessEventType*) NN_NOEXCEPT;

void   WaitInterProcessEvent(InterProcessEventType*) NN_NOEXCEPT;
bool   TryWaitInterProcessEvent(InterProcessEventType*) NN_NOEXCEPT;
bool   TimedWaitInterProcessEvent(InterProcessEventType*, TimeSpan) NN_NOEXCEPT;

void   SignalInterProcessEvent(InterProcessEventType*) NN_NOEXCEPT;
void   ClearInterProcessEvent(InterProcessEventType*) NN_NOEXCEPT;

NativeHandle GetReadableHandleOfInterProcessEvent(const InterProcessEventType*) NN_NOEXCEPT;
NativeHandle GetWritableHandleOfInterProcessEvent(const InterProcessEventType*) NN_NOEXCEPT;

void   InitializeMultiWaitHolder(MultiWaitHolderType*, InterProcessEventType*) NN_NOEXCEPT;

//-----------------------------------------------------------------------------

}}} // namespace nn::os::detail

