﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_Common.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_FiberTypes.h>


namespace nn { namespace os { namespace detail {

// ファイバ呼び出し用のラッパ関数。実装はアセンブラ。
FiberType* CallFiberFunction(FiberFunction function, void *argument) NN_NOEXCEPT;

// ファイバのコンテキスト切り替え関数。実装はアセンブラ。
void DispatchFiberContext(FiberContextForHorizon** current, FiberContextForHorizon** next) NN_NOEXCEPT;

//--------------------------------------------------------------------------

class FiberImplByHorizon
{
public:
    static void Initialize(FiberType* fiber, void (*entryPoint)(FiberType*)) NN_NOEXCEPT;
    static void Finalize(FiberType* fiber) NN_NOEXCEPT
    {
        NN_UNUSED(fiber);
    }

    static void ConvertThreadToFiber(FiberType* fiber) NN_NOEXCEPT
    {
        NN_UNUSED(fiber);
    }

    static void ConvertFiberToThread(FiberType* fiber) NN_NOEXCEPT
    {
        NN_UNUSED(fiber);
    }

    static void Switch(FiberType* currentFiber, FiberType* nextFiber) NN_NOEXCEPT
    {
        DispatchFiberContext(&currentFiber->_impl._sp, &nextFiber->_impl._sp);
    }

    static bool MapAliasStack(const void* to, const void* from, size_t size) NN_NOEXCEPT;
    static bool UnmapAliasStack(const void* to, const void* from, size_t size) NN_NOEXCEPT;
};

typedef FiberImplByHorizon  FiberImpl;

//--------------------------------------------------------------------------

}}} // namespace nn::os::detail

