﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>

#include "os_Diag.h"
#include "os_Common.h"


//---------------------------------------------------------------------------
//  C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------
//   OS ライブラリ内で未実装を宣言し、実行を停止
NN_NORETURN void NotImplemented(const char*  functionName, int line) NN_NOEXCEPT
{
    NN_UNUSED(line);
    NN_UNUSED(functionName);
    NN_ABORT(NN_TEXT_OS("%s 関数は未実装です（line:%d）"), functionName, line);
}

}   // namespace detail
}}  // namespace nn::os

