﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    #include "os_Common-compiler.vc.h"
#elif defined(NN_BUILD_CONFIG_COMPILER_GCC)
    #include "os_Common-compiler.gcc.h"
#elif defined(NN_BUILD_CONFIG_COMPILER_CLANG)
    #include "os_Common-compiler.clang.h"
#elif defined(NN_BUILD_CONFIG_COMPILER_GHS)
    #include "os_Common-compiler.ghs.h"
#elif defined(NN_BUILD_CONFIG_COMPILER_OASIS_CAFE_CLANG)
    #include "os_Common-compiler.oasis-cafe-clang.h"
#else
    #error   "未サポートのコンパイラ種別が指定されています。"
#endif


//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

#if defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_STRONG_ENUMS)
enum class TriBool : int
{
    False         = 0,
    True          = 1,
    Indeterminate = 2,
};
#endif

}   // namespace detail
}}  // namespace nn::os

