﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Macro.h>

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

class AslrSpaceManagerImplByWin32
{
public:
    // Horizon/64bit 環境を模倣した仮想アドレス空間を定義しておく。
    // これらの空間は単なるアドレス管理用で、実際にアクセスされることはない。
    static uint64_t  GetAslrSpaceBeginAddress() NN_NOEXCEPT
    {
        return 0x00200000ull; // 2MB (ガード用に空けておく)
    }
    static uint64_t  GetAslrSpaceEndAddress() NN_NOEXCEPT
    {
        return 0x1000000000ull; // 64GB
    }

    // ヒープ領域
    // 8GB ～ 12GB の領域に作成
    static uint64_t GetHeapSpaceBeginAddress() NN_NOEXCEPT
    {
        return 0x200000000ull; // 8GB
    }
    static uint64_t GetHeapSpaceSize() NN_NOEXCEPT
    {
        return 0x100000000ull; // 4GB
    }

    // 予約領域
    // あえて ASLR 領域の bottom に貼り付ける
    static uint64_t GetReservedSpaceBeginAddress() NN_NOEXCEPT
    {
        return 0xF00000000ull; // 60GB
    }
    static uint64_t GetReservedSpaceSize() NN_NOEXCEPT
    {
        return 0x100000000ull; // 4GB
    }
};

typedef AslrSpaceManagerImplByWin32    AslrSpaceManagerImpl;

//--------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

