﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/mbuf/mbuf_Definitions.h>

namespace nn { namespace mbuf
{

    void InitializeMbuf(Mbuf* mbuf, size_t unitSize, int poolId) NN_NOEXCEPT;
    int32_t* GetNextFreeIndexPtr(Mbuf* mbuf) NN_NOEXCEPT;
    void SetNextFreeIndex(Mbuf* mbuf, int freeIndex) NN_NOEXCEPT;
    int GetNextFreeIndex(Mbuf* mbuf) NN_NOEXCEPT;
    Mbuf* GetNextMbuf(Mbuf* mbuf) NN_NOEXCEPT;
    const Mbuf* GetNextMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    Mbuf* GetPreviousMbuf(Mbuf* mbuf) NN_NOEXCEPT;
    const Mbuf* GetPreviousMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    void SetNextMbuf(Mbuf* mbuf, Mbuf* pMbuf) NN_NOEXCEPT;
    void SetPreviousMbuf(Mbuf* mbuf, Mbuf* pMbuf) NN_NOEXCEPT;
    bool IsLinkingMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    Mbuf* UnlinkMbuf(Mbuf* mbuf) NN_NOEXCEPT;
    void CopyFromMbuf(Mbuf* mbuf, const Mbuf* pSource) NN_NOEXCEPT;
    Mbuf* GetTailMbuf(Mbuf* mbuf) NN_NOEXCEPT;
    Mbuf* GetHeadMbuf(Mbuf* mbuf) NN_NOEXCEPT;
    size_t SetLengthTrimedMbuf(Mbuf* mbuf, size_t len) NN_NOEXCEPT;
    size_t GetLengthMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    void SetLengthMbuf(Mbuf* mbuf, size_t len) NN_NOEXCEPT;
    MbufPacketHeaderFlag GetFlagsMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    void SetFlagsMbuf(Mbuf* mbuf, MbufPacketHeaderFlag flags) NN_NOEXCEPT;
    void SetTypeMbuf(Mbuf* mbuf, int type) NN_NOEXCEPT;
    int GetTypeMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    void SetProtocolMbuf(Mbuf* mbuf, int protocol) NN_NOEXCEPT;
    int GetProtocolMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    void SetTopMbuf(Mbuf* mbuf, size_t top) NN_NOEXCEPT;
    size_t GetWritableLengthMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    size_t GetTopMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    void* GetTopPtrMbuf(Mbuf* mbuf, size_t offset = 0) NN_NOEXCEPT;
    const void* GetTopPtrMbuf(const Mbuf* mbuf, size_t offset = 0) NN_NOEXCEPT;
    bool IsAlignedMbuf(uintptr_t address, size_t align, size_t offset) NN_NOEXCEPT;
    bool IsDataAlignedMbuf(Mbuf* mbuf, size_t align, size_t offset = 0) NN_NOEXCEPT;
    size_t GetCapacityMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    size_t GetUnitSizeMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    int GetPoolIdMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    size_t GetTotalLengthMbuf(const Mbuf* mbuf) NN_NOEXCEPT;
    bool CopyChainToMbuf(const Mbuf* mbuf, void* pDst, size_t offset, size_t len) NN_NOEXCEPT;
    void LinkMbuf(Mbuf* mbuf, Mbuf* pNext) NN_NOEXCEPT;

}} // namespace nn::mbuf
