﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ldr/ldr_DebugMonitorApi.h>
#include <nn/ldr/detail/ldr_DebugMonitorInterface.h>
#include <nn/ldr/ldr_ShellApi.h>
#include <nn/ldr/detail/ldr_ShellInterface.h>

#include <nn/svc/svc_Handle.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn { namespace ldr {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<10 * 1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::ldr::detail::IDebugMonitorInterface> g_RefDebugMonitorInterface;
        bool g_IsInitialized = false;
    }

    Result InitializeForDebugMonitor() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<nn::ldr::detail::IDebugMonitorInterface, MyAllocator::Policy>(
            &g_RefDebugMonitorInterface, nn::ldr::detail::PortNameForDebugMonitor);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result FinalizeForDebugMonitor() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( g_IsInitialized );
        nn::sf::ReleaseSharedObject(g_RefDebugMonitorInterface.Detach());

        g_IsInitialized = false;
        return ResultSuccess();
    }

    Result SetProgramArgument2(ncm::ProgramId programId, const void* pArgument, size_t size) NN_NOEXCEPT
    {
        auto inArgument = nn::sf::InArray<Bit8>(reinterpret_cast<const Bit8*>(pArgument), size);
        return g_RefDebugMonitorInterface->SetProgramArgument2(programId, inArgument, size);
    }

    Result FlushArguments2() NN_NOEXCEPT
    {
        return g_RefDebugMonitorInterface->FlushArguments2();
    }

    Result GetProcessModuleInfo(int* pOutCount, ldr::ModuleInfo* pBuffer, int num, nn::os::ProcessId id) NN_NOEXCEPT
    {
        auto outBuffer = nn::sf::OutArray<ldr::ModuleInfo>(pBuffer, num);
        return g_RefDebugMonitorInterface->GetProcessModuleInfo(
            reinterpret_cast<int32_t*>(pOutCount), outBuffer, id);
    }

}}
