﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/fs/fs_ResultHandler.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
//--------------------------------------------------------------------------
//  プロトタイプ宣言など
//
namespace nn { namespace os {
    void InitializeVirtualAddressMemory() NN_NOEXCEPT;
}}

namespace nn { namespace oe {
    void Initialize() NN_NOEXCEPT;
}}

namespace nn {namespace aoc {
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
}}

namespace nn { namespace pctl {
    void Initialize() NN_NOEXCEPT;
}}

namespace nn { namespace diag {
    void InitializeApplicationAbortObserver() NN_NOEXCEPT;
}}

extern "C" void nndiagStartup();

namespace nn { namespace fs {
    /**
    *   @brief      アクセスログの設定を変更します。
    *
    *   @param[in]  isEnabled    true なら有効化、false なら無効化
    *
    *   @return     なし
    */
    void SetLocalApplicationAccessLog(bool isEnabled) NN_NOEXCEPT;

    void InitializeForApplication() NN_NOEXCEPT;
}}

#if !defined(NN_SDK_BUILD_RELEASE)
//--------------------------------------------------------------------------
//  Release ビルド以外の時のみ、
//  アプリにデフォルトユーザ例外ハンドラ専用のスタックを用意する。
//  これにより、アプリでスタックオーバーフロー等の例外が発生した時に、
//  デフォルトユーザ例外ハンドラがログ出力される。
//
namespace {
NN_ALIGNAS(4096) char g_DefaultUserExceptionHandlerStackForApplication[0x4000];
}

extern "C" void* nnosGetDefaultUserExceptionStackForApplication(size_t* pOutSize)
{
    *pOutSize = sizeof(g_DefaultUserExceptionHandlerStackForApplication);
    return &g_DefaultUserExceptionHandlerStackForApplication;
}
#endif

//--------------------------------------------------------------------------
//  本関数は、アプリケーションでのみ実行される初期化関数です。
//  アプリケーション以外にはリンクすらされません。
//
//  本関数は Horizon 環境専用で init ライブラリ内から以下のタイミングで呼ばれます。
//
//    - nndiagStartup() から戻ってきた直後
//    - nninitStartup() の直前
//
//  そのため、本関数では以下の状態で呼ばれてきます。
//
//    - data, bss のセクションが初期化済み
//    - nn::os ライブラリの全ての API が利用可能
//    - nn::sf による IPC が利用可能
//    - スタックは、メインスレッドのスタックを消費
//
//  一方、以下の機能は利用できません。
//
//    - malloc() や new は未初期化のため利用不可
//    - 静的オブジェクトのコンストラクタはまだ未実行
//
//
extern "C" void nninitInitializeSdkModule()
{
    nndiagStartup();

    nn::os::InitializeVirtualAddressMemory();

// (SIGLO-83559) nnSdk を Generic でビルドできるようにするための暫定的な実装分岐
#if defined(NN_BUILD_CONFIG_BDSLIMX6) || \
    defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || \
    defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || \
    defined(NN_BUILD_CONFIG_HARDWARE_NX)
    nn::oe::Initialize();

    nn::aoc::Initialize();
#endif
    nn::fs::InitializeForApplication();
    nn::fs::SetLocalApplicationAccessLog(true);

// (SIGLO-83559) nnSdk を Generic でビルドできるようにするための暫定的な実装分岐
#if defined(NN_BUILD_CONFIG_BDSLIMX6) || \
    defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || \
    defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || \
    defined(NN_BUILD_CONFIG_HARDWARE_NX)
    nn::pctl::Initialize();
#endif

    nn::fs::SetResultHandledByApplication(true);

// (SIGLO-83559) nnSdk を Generic でビルドできるようにするための暫定的な実装分岐
#if defined(NN_BUILD_CONFIG_BDSLIMX6) || \
    defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || \
    defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || \
    defined(NN_BUILD_CONFIG_HARDWARE_NX)
    nn::diag::InitializeApplicationAbortObserver();
#endif
}

//--------------------------------------------------------------------------
//  本関数は、アプリケーションでのみ実行される終了関数です。
//  アプリケーション以外にはリンクすらされません。
//
//  本関数は Horizon 環境専用で init ライブラリ内から以下のタイミングで呼ばれます。
//
//    - nnMain() から戻ってきた直後
//    - nnosQuickExit() の直前
//
//  アプリが nnMain() から返らずに終了する場合は本関数は呼ばれません。
//
//
extern "C" void nninitFinalizeSdkModule()
{
// (SIGLO-83559) nnSdk を Generic でビルドできるようにするための暫定的な実装分岐
#if defined(NN_BUILD_CONFIG_BDSLIMX6) || \
    defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || \
    defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || \
    defined(NN_BUILD_CONFIG_HARDWARE_NX)
    nn::aoc::Finalize();
#endif
}
#endif /* defined(NN_BUILD_CONFIG_OS_HORIZON) */
