﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/htc/tenv/htc_Tenv.h>
#include <nn/htc/tenv/htc_TenvPath.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_StringUtil.h>

#include "htc_TenvAllocator.h"

namespace nn { namespace htc { namespace tenv { namespace detail {

    struct DefinitionFileInfo : public util::IntrusiveListBaseNode<DefinitionFileInfo>
    {
        Bit64 processId;
        Path path;

        DefinitionFileInfo(Bit64 processId, Path* path) NN_NOEXCEPT : processId(processId)
        {
            NN_SDK_REQUIRES_NOT_NULL(path);
            util::Strlcpy(this->path.string, path->string, PathLengthMax);
        }

        static void* operator new(size_t size) NN_NOEXCEPT
        {
            return Allocate(size);
        }

        static void operator delete(void* p, size_t size) NN_NOEXCEPT
        {
            Deallocate(p, size);
        }
    };

}}}}
