﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Thread.h>

#include <nn/gc/gc.h>
#include <nn/gc/detail/gc_Log.h>
#include <nn/gc/detail/gc_GeneralIo.h>

#include <nn/gpio/gpio_PadAccessorDev.h>

#include <nn/pcv/pcv.h>

namespace nn { namespace gc {
namespace detail {

GeneralIo::GeneralIo() NN_NOEXCEPT
{

}

GeneralIo& GeneralIo::GetInstance() NN_NOEXCEPT
{
    static GeneralIo s_Instance;
    return s_Instance;
}

void GeneralIo::Initialize() NN_NOEXCEPT
{
    nn::os::CreateSystemEvent(&m_DetectEvent, nn::os::EventClearMode_ManualClear, true);
    nn::os::ClearSystemEvent(&m_DetectEvent);

    m_IsDetectPinOnForTest = false;
}

void GeneralIo::Finalize() NN_NOEXCEPT
{

}

nn::Result GeneralIo::SetGpioResetPin(const bool isOn) NN_NOEXCEPT
{
    NN_UNUSED(isOn);
    NN_RESULT_SUCCESS;
}


bool GeneralIo::GetGpioDetectPin() NN_NOEXCEPT
{
    return m_IsDetectPinOnForTest;
}

void GeneralIo::ClearGpioDetectEvent() NN_NOEXCEPT
{
    nn::os::ClearSystemEvent(&m_DetectEvent);
}

bool GeneralIo::IsGpioDetectWakeEventActive() NN_NOEXCEPT
{
    return false;
}

nn::Result GeneralIo::WaitGpioDetectPin(const bool isOn, const bool isOldPlatform) NN_NOEXCEPT
{
    NN_UNUSED(isOn);
    NN_UNUSED(isOldPlatform);
    NN_RESULT_SUCCESS;
}

nn::Result GeneralIo::SetGcPower(const bool isOn) NN_NOEXCEPT
{
    NN_UNUSED(isOn);
    NN_RESULT_SUCCESS;
}

nn::Result GeneralIo::SetGcPowerImpl(const bool isOn, const BusPower power) NN_NOEXCEPT
{
    NN_UNUSED(isOn);
    NN_UNUSED(power);
    NN_RESULT_SUCCESS;
}

nn::Result GeneralIo::ReleaseAsicReset() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result GeneralIo::HoldAsicReset() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void GeneralIo::SetDetectPinStateForTest(bool isOn) NN_NOEXCEPT
{
    m_IsDetectPinOnForTest = isOn;
    nn::os::SignalSystemEvent(&m_DetectEvent);
}

} } }
