﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gc/gc.h>
#include <nn/gc/detail/gc_Log.h>

#include <nn/gc/detail/gc_DataIo.h>
#include <nn/gc/detail/gc_GcCrypto.h>
#include <nn/gc/detail/gc_StateMachine.h>

namespace nn { namespace gc {
namespace detail {

DataIo::DataIo() NN_NOEXCEPT
{
    m_MaxRetryCount = 0;
    m_IsDeviceVirtualAddressRegistered = false;
}

DataIo& DataIo::GetInstance() NN_NOEXCEPT
{
    static DataIo s_Instance;
    return s_Instance;
}

void DataIo::Initialize() NN_NOEXCEPT
{

}

void DataIo::RegisterDeviceVirtualAddress(uintptr_t bufferAddress, size_t bufferSize, nn::dd::DeviceVirtualAddress bufferDeviceVirtualAddress) NN_NOEXCEPT
{
    NN_UNUSED(bufferAddress);
    NN_UNUSED(bufferSize);
    NN_UNUSED(bufferDeviceVirtualAddress);
}

nn::Result DataIo::Activate() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void DataIo::Deactivate() NN_NOEXCEPT
{

}

void DataIo::UnregisterDeviceVirtualAddress(uintptr_t bufferAddress, size_t bufferSize, nn::dd::DeviceVirtualAddress bufferDeviceVirtualAddress) NN_NOEXCEPT
{
    NN_UNUSED(bufferAddress);
    NN_UNUSED(bufferSize);
    NN_UNUSED(bufferDeviceVirtualAddress);
}

nn::Result DataIo::Finalize() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::SendCommandDataRead(char* outAlignedBuffer, const size_t bufferLength) NN_NOEXCEPT
{
    NN_UNUSED(outAlignedBuffer);
    NN_UNUSED(bufferLength);
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::SendCommandDataWrite(char* workAlignedDataBuffer, const size_t bufferLength) NN_NOEXCEPT
{
    NN_UNUSED(workAlignedDataBuffer);
    NN_UNUSED(bufferLength);
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::GetDeviceStatus(BitPack32 *outStatus) NN_NOEXCEPT
{
    outStatus->Set<AsicDeviceStatus::asicError>(GcDeviceStatusAsicError_Boot);
    NN_RESULT_SUCCESS;
}

void DataIo::PrintDeviceStatus() NN_NOEXCEPT
{

}

nn::Result DataIo::SendOperationStart(char* workAlignedOperationBuffer, const size_t bufferLength) NN_NOEXCEPT
{
    NN_UNUSED(workAlignedOperationBuffer);
    NN_UNUSED(bufferLength);
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::FinishOperation() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::AbortGcAsicOperation() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::PutGcAsicToSleep() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::AwakenGcAsic() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void DataIo::PutSdmmcToSleep() NN_NOEXCEPT
{

}

Result DataIo::AwakenSdmmc() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::UpdateKey() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void DataIo::SignalRemovedEvent() NN_NOEXCEPT
{

}

void DataIo::ClearRemovedEvent() NN_NOEXCEPT
{

}

nn::Result DataIo::SendSdmmcCommandWithRetry(sdmmcCommandFunctionPointer pFunction) NN_NOEXCEPT
{
    NN_UNUSED(pFunction);
    NN_RESULT_SUCCESS;
}

nn::Result DataIo::SendSdmmcCommandWithRetry(sdmmcCommandFunctionWithBufferPointer pFunction, const void* operationBuffer, const size_t operationBufferSize) NN_NOEXCEPT
{
    NN_UNUSED(pFunction);
    NN_UNUSED(operationBuffer);
    NN_UNUSED(operationBufferSize);
    NN_RESULT_SUCCESS;
}

} } }
