﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/fssystem/fs_ServiceContext.h>
#include <nn/os/os_SdkThreadLocalStorage.h>

namespace nn { namespace fssystem {

namespace {

    // Generic 版でアプリケーション側の TLS スロットを消費しないようにシステム側の TLS スロットを使用
    os::SdkThreadLocalStorage g_TlsServiceContext;

}

NN_DEFINE_STATIC_CONSTANT(const Bit64 ServiceContext::InvalidProcessId);
NN_DEFINE_STATIC_CONSTANT(const int ServiceContext::InvalidPrioritySessionType);

void RegisterServiceContext(ServiceContext* pContext) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pContext);
    NN_SDK_REQUIRES_EQUAL(g_TlsServiceContext.GetValue(), static_cast<uintptr_t>(0));

    g_TlsServiceContext.SetValue(reinterpret_cast<uintptr_t>(pContext));
}

void UnregisterServiceContext() NN_NOEXCEPT
{
    g_TlsServiceContext.SetValue(0);
}

ServiceContext* GetServiceContext() NN_NOEXCEPT
{
    auto pContext = reinterpret_cast<ServiceContext*>(g_TlsServiceContext.GetValue());
#if !defined(NN_BUILD_CONFIG_OS_WIN)
    NN_SDK_ASSERT_NOT_NULL(pContext);
#endif
    return pContext;
}

const ServiceContext& GetServiceContextReadOnly() NN_NOEXCEPT
{
    auto pContext = reinterpret_cast<ServiceContext*>(g_TlsServiceContext.GetValue());
    if( pContext != nullptr )
    {
        return *pContext;
    }
    static const ServiceContext s_EmptyContext;
    return s_EmptyContext;
}

}}
