﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.fs
{
    [CppRefPath(@"<nn/fs/fs_FileSystemForDebug.h>")]
    [ExternalStruct(32, 8)]
    public struct FileTimeStampRaw
    {
    }

    [CppRefPath(@"<nn/fs/fs_QueryRange.h>")]
    [ExternalStruct(64, 8)]
    public struct FileQueryRangeInfo
    {
    }
}

namespace nn.fs.detail
{
    [CppRefPath(@"<nn/fs/detail/fs_IFileSystemPointer.h>")]
    public struct IFileSystemPointer
    {
    }
}

namespace nn.fssrv.sf
{
    [CppRefPath(@"<nn/fssrv/sf/fssrv_IFile.h>")]
    public struct ReadOption
    {
        public uint32_t reserved;
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_IFile.h>")]
    public struct WriteOption
    {
        public uint32_t flags;
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_IFileSystem.h>")]
    [LargeData]
    public struct Path
    {
        [FixedArray(769)]
        public char_t[] str;
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_IFile.h>")]
    public interface IFile : IServiceObject
    {
        [MethodId(0)]
        Result Read(Out<int64_t> outValue, int64_t offset, [NonSecureMapTransfer] OutBuffer buffer, int64_t size, ReadOption option);

        [MethodId(1)]
        Result Write(int64_t offset, [NonSecureMapTransfer] InBuffer buffer, int64_t size, WriteOption option);

        [MethodId(2)]
        Result Flush();

        [MethodId(3)]
        Result SetSize(int64_t size);

        [MethodId(4)]
        Result GetSize(Out<int64_t> outValue);

        [MethodId(5)]
        Result OperateRange(Out<nn.fs.FileQueryRangeInfo> outQueryRangeInfo, int32_t operationId,  int64_t offset, int64_t size);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_IDirectory.h>")]
    public interface IDirectory : IServiceObject
    {
        [MethodId(0)]
        Result Read(Out<int64_t> outValue, OutBuffer outEntries);

        [MethodId(1)]
        Result GetEntryCount(Out<int64_t> outValue);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_IFileSystem.h>")]
    public interface IFileSystem : IServiceObject
    {
        [MethodId(-1)]
        [UseCmif(false)]
        Result GetImpl(Out<nn.fs.detail.IFileSystemPointer> outValue);

        [MethodId(0)]
        Result CreateFile(Path path, int64_t size, uint32_t option);

        [MethodId(1)]
        Result DeleteFile(Path path);

        [MethodId(2)]
        Result CreateDirectory(Path path);

        [MethodId(3)]
        Result DeleteDirectory(Path path);

        [MethodId(4)]
        Result DeleteDirectoryRecursively(Path path);

        [MethodId(5)]
        Result RenameFile(Path currentPath, Path newPath);

        [MethodId(6)]
        Result RenameDirectory(Path currentPath, Path newPath);

        [MethodId(7)]
        Result GetEntryType(Out<uint32_t> outValue, Path path);

        [MethodId(8)]
        Result OpenFile(Out<IFile> outValue, Path path, uint32_t mode);

        [MethodId(9)]
        Result OpenDirectory(Out<IDirectory> outValue, Path path, uint32_t mode);

        [MethodId(10)]
        Result Commit();

        [MethodId(11)]
        Result GetFreeSpaceSize(Out<int64_t> outValue, Path path);

        [MethodId(12)]
        Result GetTotalSpaceSize(Out<int64_t> outValue, Path path);

        [MethodId(13)]
        Result CleanDirectoryRecursively(Path path);

        [MethodId(14)]
        Result GetFileTimeStampRaw(Out<nn.fs.FileTimeStampRaw> outTimeStamp, Path path);

        [MethodId(15)]
        Result QueryEntry([NonSecureMapTransfer] OutBuffer outBuffer, [NonSecureMapTransfer] InBuffer inBuffer, int32_t queryId, Path path);

    }
}
