﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>

#include <nn/fs/fs_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/fssystem/fs_AllocatorUtility.h>
#include <nn/fssystem/fs_TmFileSystem.h>

#include <nn/fssrv/fscreator/fssrv_TargetManagerFileSystemCreator.h>

namespace nn { namespace fssrv { namespace fscreator {

    TargetManagerFileSystemCreator::TargetManagerFileSystemCreator() NN_NOEXCEPT
    {
    }

    Result TargetManagerFileSystemCreator::Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue) NN_NOEXCEPT
    {
        std::shared_ptr<nn::fssystem::TmFileSystem> pFs = fssystem::AllocateShared<nn::fssystem::TmFileSystem>();
        NN_RESULT_THROW_UNLESS(pFs, nn::fs::ResultAllocationMemoryFailedInTargetManagerFileSystemCreatorA());
        NN_RESULT_DO(pFs->Initialize());
        *outValue = std::move(pFs);
        NN_RESULT_SUCCESS;
    }

}}}
