﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <mutex>

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_Bis.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/fssrv/fscreator/fssrv_SdCardProxyFileSystemCreatorHostFs.h>
#include "../detail/fssrv_Utility.h"

#include <nn/fssystem/fs_Utility.h>

namespace nn { namespace fssrv { namespace fscreator {

Result SdCardProxyFileSystemCreatorHostFs::OpenSdCardFileSystem(std::shared_ptr<nn::fs::fsa::IFileSystem>* pOutFileSystem, bool isUncache) NN_NOEXCEPT
{
    std::shared_ptr<nn::fs::fsa::IFileSystem> pFileSystem;

    NN_UNUSED(isUncache);

    NN_RESULT_DO(m_pHostFsCreator->Create(&pFileSystem, detail::GetExecutionDirectoryPath()));

    // TORIAEZU: "実行ディレクトリ/sdcard/" を SD カードディレクトリとする
    const char* const SdCardDirectoryName = "/sdcard";

    // 無かったら作成
    NN_RESULT_DO(detail::EnsureDirectory(pFileSystem.get(), SdCardDirectoryName));

    // ディレクトリを返す
    NN_RESULT_DO(detail::CreateSubDirectoryFileSystem(pOutFileSystem, std::move(pFileSystem), SdCardDirectoryName));

    NN_RESULT_SUCCESS;
}

Result SdCardProxyFileSystemCreatorHostFs::Create(std::shared_ptr<fs::fsa::IFileSystem>* pOutFileSystem) NN_NOEXCEPT
{
    std::shared_ptr<nn::fs::fsa::IFileSystem> pFileSystem;
    bool isUncache = false;
    NN_RESULT_DO(OpenSdCardFileSystem(pOutFileSystem, isUncache));
    NN_RESULT_SUCCESS;
}

Result SdCardProxyFileSystemCreatorHostFs::Format(bool isUncache) NN_NOEXCEPT
{
    NN_UNUSED(isUncache);
    NN_RESULT_SUCCESS;
}


Result SdCardProxyFileSystemCreatorHostFs::Format() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void SdCardProxyFileSystemCreatorHostFs::Initialize(fs::FileSystemProxyErrorInfo* pErrorInfo, os::Mutex* pErrorInfoMutex) NN_NOEXCEPT
{
    NN_UNUSED(pErrorInfo);
    NN_UNUSED(pErrorInfoMutex);
}



}}}
