﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <mutex>

#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_FormatString.h>

#include <nn/fssystem/fs_AllocatorUtility.h>
#include <nn/fssystem/fs_HostFileSystem.h>

#include <nn/fssrv/fscreator/fssrv_HostFileSystemCreator.h>

namespace nn { namespace fssrv { namespace fscreator {

    HostFileSystemCreator::HostFileSystemCreator(bool isEnabled) NN_NOEXCEPT
      : m_RemoteFsMark(0),
        m_IsEnabled(isEnabled)
    {
    }

    Result HostFileSystemCreator::Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue) NN_NOEXCEPT
    {
        if (!m_IsEnabled)
        {
            return fs::ResultUnsupportedOperation();
        }
        return HostFileSystemCreator::Create(outValue, "");
    }

    Result HostFileSystemCreator::Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, const char* path) NN_NOEXCEPT
    {
        if (!m_IsEnabled)
        {
            return fs::ResultUnsupportedOperation();
        }

#if defined(NN_BUILD_CONFIG_OS_WIN32)
        std::shared_ptr<fssystem::HostFileSystem> pFs = fssystem::AllocateShared<fssystem::HostFileSystem>();
        NN_RESULT_THROW_UNLESS(pFs, nn::fs::ResultAllocationMemoryFailedInHostFileSystemCreatorA());
        NN_RESULT_DO(pFs->Initialize(path));
        *outValue = std::move(pFs);
        NN_RESULT_SUCCESS;
#else
        // TODO: TargetManagerFileSystemCreator と統合？
        // ここに到達した場合はプログラミングミスなので ABORT する
        NN_ABORT();
#endif
    }

}}}
