﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <mutex>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_SdCardPrivate.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>

#include <nn/fssrv/fscreator/fssrv_EncryptedFileSystemCreator.h>
#include <nn/fssystem/fs_AllocatorUtility.h>
#include <nn/fssystem/fs_AesXtsFileSystem.h>

using namespace nn::fssrv::detail;
using namespace nn::fssystem;
using namespace nn::fs;

namespace {
    const size_t XtsBlockSize = 16 * 1024;
}

namespace nn { namespace fssrv { namespace fscreator {

NN_DEFINE_STATIC_CONSTANT(const int IEncryptedFileSystemCreator::KeyIdCount);

EncryptedFileSystemCreator::EncryptedFileSystemCreator(const Configuration& configuration) NN_NOEXCEPT
    : m_pGenerateKey(configuration.pGetKeyFunction)
    , m_pGenerateRandom(configuration.pGenerateRandomFunction)
{
}

Result EncryptedFileSystemCreator::Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, std::shared_ptr<nn::fs::fsa::IFileSystem> pFileSystem, KeyId id, const EncryptionSeed& seed) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outValue);
    NN_SDK_REQUIRES_NOT_NULL(pFileSystem.get());

    Key key[2]; // AES-ECB 用鍵、MAC用鍵
    m_pGenerateKey(key, 2, id, seed);

    auto pEncryptedFileSystem = AllocateShared<AesXtsFileSystem>();
    NN_RESULT_THROW_UNLESS(pEncryptedFileSystem, ResultAllocationMemoryFailedInEncryptedFileSystemCreatorA());
    NN_RESULT_DO(pEncryptedFileSystem->Initialize(std::move(pFileSystem), &key[0], sizeof(key[0]), &key[1], sizeof(key[1]), m_pGenerateRandom, XtsBlockSize));

    *outValue = std::move(pEncryptedFileSystem);

    NN_RESULT_SUCCESS;
}

}}}
