﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/fs/fs_Bis.h>
#include "fssrv_FatFileSystemCacheManager.h"

namespace nn { namespace fs { namespace fsa {
class IFileSystem;
}}}

namespace nn { namespace fssrv { namespace detail {

FatDriveId GetFatDriveId(fs::BisPartitionId id);
Result GetResultForInvalidFatFormat(fs::BisPartitionId id);
Result GetResultForUsableSpaceNotEnough(fs::BisPartitionId id);
Result CreateSubDirectoryFileSystem(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, std::shared_ptr<nn::fs::fsa::IFileSystem> fileSystem, const char* path, bool isUncPreserved) NN_NOEXCEPT;

Result EnsureParentDirectory(nn::fs::fsa::IFileSystem* pFileSystem, const char* path) NN_NOEXCEPT;
Result EnsureDirectory(nn::fs::fsa::IFileSystem* pFileSystem, const char* path) NN_NOEXCEPT;
Result CreateSubDirectoryFileSystem(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, std::shared_ptr<nn::fs::fsa::IFileSystem> fileSystem, const char* path) NN_NOEXCEPT;
Result CreateSubDirectoryFileSystem(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, std::shared_ptr<nn::fs::fsa::IFileSystem> fileSystem, const char* path, bool isUncPreserved) NN_NOEXCEPT;
Result WrapSubDirectory(std::shared_ptr<nn::fs::fsa::IFileSystem>* pOutFileSystem, std::shared_ptr<nn::fs::fsa::IFileSystem> pBaseFileSystem, const char* rootDirectoryPath) NN_NOEXCEPT;
Result WrapSubDirectory(std::shared_ptr<nn::fs::fsa::IFileSystem>* pOutFileSystem, std::shared_ptr<nn::fs::fsa::IFileSystem> pBaseFileSystem, const char* rootDirectoryPath, bool isDirectoryCreate) NN_NOEXCEPT;

const char* GetExecutionDirectoryPath();

}}}
