﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>

#include <nn/fs/detail/fs_Newable.h>
#include <nn/fs/fsa/fs_IFile.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/fs/fs_Utility.h>
#include <nn/fs/fs_SaveDataTransferVersion2.h>

#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include "fssrv_SaveDataTransferVersion2.h"
#include <nn/sf/sf_ISharedObject.h>
#include <nn/fssystem/fs_ProxyStorage.h>


namespace nn { namespace fssrv { namespace detail {

    class SaveDataPorterCore
    {
    public:
        static Result CreateForExport(std::shared_ptr<SaveDataPorterCore>* pOutValue, std::shared_ptr<fs::IStorage> saveDataConcatenatedStorage, const fs::SaveDataExtraData& extraData, std::unique_ptr<InitialDataVersion2Detail::Content>&& initialDataTheirs) NN_NOEXCEPT;
        static Result CreateForImport(std::shared_ptr<SaveDataPorterCore>* pOutValue, std::shared_ptr<fs::IStorage> saveDataConcatenatedStorage, std::shared_ptr<fs::fsa::IFileSystem> fileSystem, std::unique_ptr<InitialDataVersion2Detail::Content>&& initialDataTheirs) NN_NOEXCEPT;

    public:
        SaveDataPorterCore(std::shared_ptr<fssystem::ProxyStorage> saveDataConcatenatedStorage, const fs::SaveDataExtraData& extraData, std::unique_ptr<InitialDataVersion2Detail::Content>&& initialDataTheirs) NN_NOEXCEPT;
        SaveDataPorterCore(std::shared_ptr<fssystem::ProxyStorage> saveDataConcatenatedStorage, std::shared_ptr<fs::fsa::IFileSystem> fileSystem, std::unique_ptr<InitialDataVersion2Detail::Content>&& initialDataTheirs) NN_NOEXCEPT;

        Result SetDivisionCount(int count) NN_NOEXCEPT;
        Result OpenSaveDataDiffChunkIterator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataChunkIterator>> outValue, bool includeInitialData) NN_NOEXCEPT;
        Result OpenSaveDataChunkStorage(std::shared_ptr<fs::IStorage>* outValue, fs::SaveDataChunkId id) NN_NOEXCEPT;
        Result ReportMac(fs::SaveDataChunkId id, char* pMac, size_t macSize) NN_NOEXCEPT;
        Result ReportSize(fs::SaveDataChunkId id, int64_t size) NN_NOEXCEPT;
        Result FinalizeImport() NN_NOEXCEPT;
        Result FinalizeExport(InitialDataVersion2Detail::Content* pOutInitialData) NN_NOEXCEPT;
        int64_t GetSize(fs::SaveDataChunkId id) NN_NOEXCEPT;
        Result GetInitialDataAadTheirs(fs::detail::InitialDataAad* outValue) NN_NOEXCEPT;
        Result SetInitialDataAad(const fs::detail::InitialDataAad& aad) NN_NOEXCEPT;
        void Invalidate() NN_NOEXCEPT;

        static Result OpenSaveDataDiffChunkIteratorAll(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataChunkIterator>> outValue, bool includeInitialData, int divisionCount) NN_NOEXCEPT;

    private:
        const size_t AlignSize = 1;

    private:

        Result OpenSaveDataSubStorage(std::shared_ptr<fs::IStorage>* outValue, int index) NN_NOEXCEPT;

        Result ConstructInitialData() NN_NOEXCEPT;

    private:
        std::shared_ptr<fssystem::ProxyStorage> m_ConcatenatedStorage;
        std::shared_ptr<fs::fsa::IFileSystem> m_FileSystem;

        int m_DivisionCount = 0;
        int64_t m_DivisionSize;

        // TODO: サイズ要最適化
        std::unique_ptr<InitialDataVersion2Detail::Content> m_InitialDataTheirs;
        InitialDataVersion2Detail::Content                  m_InitialDataOurs;

        bool m_Initialized = false;
    };

}}}
