﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fssrv/fssrv_SaveDataTransferCryptoConfiguration.h>
#include <nn/fssrv/sf/fssrv_ISaveDataTransfer.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/crypto/crypto_Aes128GcmEncryptor.h>
#include "fssrv_SaveDataImporter.h"

namespace nn { namespace fssrv { namespace detail {

    struct Challenge
    {
    public:
        static const int Size = 16;

    public:
        char data[Size];
    };

    struct SaveDataTransferToken
    {
    public:
        static const int EncryptOffset = 128;
        static const int EncryptedSize = 384;
        static const int SignTargetOffset = 384;
        static const int SignTargetSize   = 128;

    public:
        char version[16];
        char tokenIv[16];
        char tokenMac[16];
        char reserved1[80];

        struct {
            char sign[256];
            struct {
                char keySeed[16];
                char iv[16];
                char challenge[16];
                char reserverd2[80];
            } signedArea;
        } encryptedArea;
    };
    NN_STATIC_ASSERT(std::is_pod<SaveDataTransferToken>::value);
    NN_STATIC_ASSERT(sizeof(SaveDataTransferToken) == 512);


    class ISaveDataTransferCoreInterface;
    class SaveDataTransferManager
    {
    public:
        SaveDataTransferManager(const SaveDataTransferCryptoConfiguration& configuration, ISaveDataTransferCoreInterface* pImpl) NN_NOEXCEPT;

        // sf
        nn::Result GetChallenge(const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result SetToken(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result OpenSaveDataExporter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataExporter>> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result OpenSaveDataImporter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataImporter>> outValue, nn::sf::Out<std::int64_t> outRequiredSize, const nn::sf::InBuffer& buffer, const nn::fs::UserId& userId, std::uint8_t saveDataSpaceId) NN_NOEXCEPT;

    private:
        nn::Result OpenSaveDataConcatenationFile(std::shared_ptr<fs::fsa::IFile>* outFile, std::unique_ptr<SaveDataMacUpdater>* outMacUpdater, const nn::fs::SaveDataInfo& info, nn::fs::OpenMode mode) NN_NOEXCEPT;

    private:
        nn::sf::SharedPointer<ISaveDataTransferCoreInterface> m_pImpl;
        const SaveDataTransferCryptoConfiguration& m_Configuration;
        bool m_IsTokenSet;
        Challenge m_Challenge;

        char m_TransferAesKeySeed[crypto::AesEncryptor128::BlockSize];
        char m_TransferAesIv[crypto::AesEncryptor128::BlockSize];

        int m_ExporterCount;
        int m_ImporterCount;
    };

}}}
