﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/fs.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>

#include <nn/fs/detail/fs_Newable.h>
#include <nn/fs/fs_Utility.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/fs/fs_SaveDataTransferVersion2.h>

#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include "fssrv_SaveDataTransferVersion2.h"
#include "fssrv_SaveDataTransferStream.h"
#include "fssrv_SaveDataTransferPorterCore.h"
#include <nn/fssystem/fs_AllocatorUtility.h>
#include <nn/fssystem/fs_Utility.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace fssrv { namespace detail {

    class SaveDataChunkEncryptor;
    class SaveDataChunkDecryptor;

    class SaveDataChunkExporter : public fs::detail::Newable
    {
    public:
        SaveDataChunkExporter(SaveDataPorterCore* pParentPorter, fs::SaveDataChunkId id, const SaveDataTransferCryptoConfiguration& configuration, const SaveDataTransferManagerVersion2::KeySeedPackage::Content& keySeedPackage) NN_NOEXCEPT;
        Result Initialize(std::shared_ptr<fs::IStorage> storage, bool compressionEnabled) NN_NOEXCEPT;
        Result Pull(nn::sf::Out<uint64_t> outValue, const nn::sf::OutBuffer& outBuffer, uint64_t size) NN_NOEXCEPT;
        Result GetRestRawDataSize(nn::sf::Out<int64_t> outValue) NN_NOEXCEPT;

    private:
        std::shared_ptr<AesGcmSource> m_Source;
        std::shared_ptr<SaveDataChunkEncryptor> m_Encryptor;

        SaveDataPorterCore* const m_pParentPorter;
        const fs::SaveDataChunkId m_Id;
        int64_t m_PulledSize = 0;
    };

    class SaveDataChunkImporter : public fs::detail::Newable
    {
    public:
        SaveDataChunkImporter(const SaveDataTransferCryptoConfiguration& configuration, const SaveDataTransferManagerVersion2::KeySeedPackage::Content& keySeedPackage) NN_NOEXCEPT;
        Result Initialize(std::shared_ptr<fs::IStorage> storage, int64_t size) NN_NOEXCEPT;
        Result Push(const nn::sf::InBuffer& inBuffer, uint64_t size) NN_NOEXCEPT;

    private:
        std::shared_ptr<AesGcmSink> m_Sink;
        std::shared_ptr<SaveDataChunkDecryptor> m_Decryptor;
        bool m_IsValid = true;
    };

}}}
