﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/detail/fs_MemoryManagementPrivate.h>

namespace nn { namespace fssrv { namespace detail {

    class PathNormalizer
    {
    public:
        enum Option
        {
            None = 0x0,
            PreserveUnc = 0x1,
            PreserveTailSeparator = 0x2,
            WithMountName = 0x4,
            AcceptEmpty = 0x8,
        };

    public:
        explicit PathNormalizer(const char* path) NN_NOEXCEPT
            : m_Result(nn::ResultSuccess()),
              m_Path(nullptr),
              m_Buffer()
        {
            m_Result = Normalize(&m_Path, &m_Buffer, path, false, false, false);
        }

        PathNormalizer(const char* path, std::underlying_type<Option>::type option) NN_NOEXCEPT
            : m_Result(nn::ResultSuccess()),
              m_Path(nullptr),
              m_Buffer()
        {
            if( (option & Option::AcceptEmpty) != 0 && path[0] == '\0' )
            {
                m_Path = path;
            }
            else
            {
                m_Result = Normalize(
                    &m_Path,
                    &m_Buffer,
                    path,
                    (option & Option::PreserveUnc) != 0,
                    (option & Option::PreserveTailSeparator) != 0,
                    (option & Option::WithMountName) != 0);
            }
        }

        nn::Result GetResult() const NN_NOEXCEPT
        {
            return m_Result;
        }

        const char* GetPath() const NN_NOEXCEPT
        {
            return m_Path;
        }

    private:
        typedef decltype(nn::fs::detail::MakeUnique<char[]>(0)) BufferType;

    private:
        static nn::Result Normalize(
            const char** outPath,
            BufferType* outBuffer,
            const char* path,
            bool isUncPreserved,
            bool isTailSeparatorPreserved,
            bool isMountNameContained) NN_NOEXCEPT;

    private:
        nn::Result m_Result;
        const char* m_Path;
        BufferType m_Buffer;
    };

}}}

