﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lr/lr_LocationResolver.h>
#include <nn/lr/lr_AddOnContentLocationResolver.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_DataId.h>
#include <nn/os/os_Mutex.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace lr {
    class LocationResolver;
    class RegisteredLocationResolver;
    struct Path;
}}

namespace nn { namespace fssrv { namespace detail {

    const ncm::StorageId StorageList[] = {
        ncm::StorageId::BuildInSystem,
        ncm::StorageId::BuildInUser,
        ncm::StorageId::Host,
        ncm::StorageId::SdCard,
        ncm::StorageId::Card,
    };
    const int NumOfResolvers = 5;

    class LocationResolverSet
    {
        NN_DISALLOW_COPY(LocationResolverSet);
        NN_DISALLOW_MOVE(LocationResolverSet);
    public:
        LocationResolverSet() NN_NOEXCEPT;
        ~LocationResolverSet() NN_NOEXCEPT;
        virtual Result ResolveProgramPath(nn::lr::Path* outValue, Bit64 id, nn::ncm::StorageId storageId) NN_NOEXCEPT; // virtual for stub test

        Result ResolveApplicationControlPath(nn::lr::Path* outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        Result ResolveApplicationHtmlDocumentPath(nn::lr::Path* outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        Result ResolveDataPath(nn::lr::Path* outValue, nn::ncm::DataId dataId, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        Result ResolveAddOnContentPath(nn::lr::Path* outValue, nn::ncm::DataId dataId) NN_NOEXCEPT;
        Result ResolveRegisteredProgramPath(nn::lr::Path* pOutValue, Bit64 id) NN_NOEXCEPT;
        Result ResolveRegisteredHtmlDocumentPath(nn::lr::Path* pOutValue, Bit64 id) NN_NOEXCEPT;

    private:
        Result GetLocationResolver(nn::lr::LocationResolver** outValue, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        Result GetRegisteredLocationResolver(nn::lr::RegisteredLocationResolver* pOutValue) NN_NOEXCEPT;
        Result GetAddOnContentLocationResolver(nn::lr::AddOnContentLocationResolver** ppOutValue) NN_NOEXCEPT;

        nn::util::optional<nn::lr::LocationResolver> m_LocationResolverSet[NumOfResolvers];
        nn::util::optional<nn::lr::AddOnContentLocationResolver> m_AddOnContentLocationResolver;
        nn::os::Mutex m_LocationResolverMutex;
    };
}}}
