﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace fssrv { namespace detail {

    class DeviceDetectionEventNotifier;
    class DeviceDetectionEventManager
    {
    public:
        DeviceDetectionEventManager() NN_NOEXCEPT;
        virtual ~DeviceDetectionEventManager() NN_NOEXCEPT;

        Result CreateNotifier(std::unique_ptr<DeviceDetectionEventNotifier>* outValue) NN_NOEXCEPT;
        void SimulateEvent() NN_NOEXCEPT;

        // この関数は直接実行しないでください。 DeviceDetectionEventNotifier のデストラクタでのみ呼ばれる想定です。
        void DeleteNotifier(DeviceDetectionEventNotifier* pEventNotifier) NN_NOEXCEPT;

    protected:
        typedef nn::util::IntrusiveList<DeviceDetectionEventNotifier, nn::util::IntrusiveListBaseNodeTraits<DeviceDetectionEventNotifier>> DeviceDetectionEventNotifierList;

        struct Parameter
        {
            DeviceDetectionEventNotifierList* pList;
            nn::os::Mutex* pMutex;
        } m_Param;
        NN_STATIC_ASSERT(std::is_pod<Parameter>::value);

        static void DeviceDetectionEventCallback(void* pArg) NN_NOEXCEPT;

    private:

        DeviceDetectionEventNotifierList m_List;
        nn::os::Mutex m_Mutex;
    };

}}}
