﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/fs/detail/fs_IFileDataCache.h>
#include <nn/fs/fs_File.h>


namespace nn { namespace fs {

namespace detail {

class LruFileDataCacheSystem;

}  // namespace nn::fs::detail


class RomFsFileDataCache : public detail::IFileDataCache
{
private:
    detail::LruFileDataCacheSystem* m_pLruFileDataCacheSystem;

public:
    RomFsFileDataCache() NN_NOEXCEPT;
    virtual ~RomFsFileDataCache() NN_NOEXCEPT;

    Result Initialize(void* pBuffer, size_t bufferSize) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    virtual void Purge(fsa::IFileSystem* fileSystem) NN_NOEXCEPT NN_OVERRIDE;

protected:
    virtual Result DoRead(
        fsa::IFile* file,
        size_t* outValue,
        int64_t offset,
        void* buffer,
        size_t size,
        const ReadOption& option,
        detail::FileDataCacheAccessResult* pAccessResult) NN_NOEXCEPT NN_OVERRIDE;
};

}}  // namespace nn::fs
