﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fsa/fs_IFile.h>
#include <nn/fs/fsa/fs_IDirectory.h>
#include <nn/fs/fsa/fs_IFileSystem.h>
#include <nn/fs/detail/fs_Newable.h>

namespace nn { namespace fs { namespace sf {
    class IFileSystem;
}}}

namespace nn { namespace fs { namespace detail {
    class FileServiceObjectAdapter : public detail::Newable, public fsa::IFile
    {
    public:
        explicit FileServiceObjectAdapter(nn::sf::SharedPointer<nn::fssrv::sf::IFile>&& fileServiceObject) NN_NOEXCEPT;
        virtual ~FileServiceObjectAdapter() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRead(size_t* outValue, int64_t offset, void* buffer, size_t size, const ReadOption& option) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoWrite(int64_t offset, const void* buffer, size_t size, const WriteOption& option) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoFlush() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoSetSize(int64_t size) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetSize(int64_t* outValue) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoOperateRange(
            void* outBuffer,
            size_t outBufferSize,
            OperationId operationId,
            int64_t offset,
            int64_t size,
            const void* inBuffer,
            size_t inBufferSize) NN_NOEXCEPT NN_OVERRIDE;
    private:
        nn::sf::SharedPointer<nn::fssrv::sf::IFile> m_fileServiceObject;
    };

    class DirectoryServiceObjectAdapter : public detail::Newable, public fsa::IDirectory
    {
    public:
        explicit DirectoryServiceObjectAdapter(nn::sf::SharedPointer<nn::fssrv::sf::IDirectory>&& directoryServiceObject) NN_NOEXCEPT;
        virtual ~DirectoryServiceObjectAdapter() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRead(int64_t* outValue, DirectoryEntry* outEntries, int64_t count) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetEntryCount(int64_t* outValue) NN_NOEXCEPT NN_OVERRIDE;
    private:
        nn::sf::SharedPointer<nn::fssrv::sf::IDirectory> m_directoryServiceObject;
    };

    class FileSystemServiceObjectAdapter : public detail::Newable, public fsa::IFileSystem
    {
        NN_DISALLOW_COPY(FileSystemServiceObjectAdapter);
    public:
        explicit FileSystemServiceObjectAdapter(nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>&& fileSystemServiceObject) NN_NOEXCEPT;
        virtual ~FileSystemServiceObjectAdapter() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCreateFile(const char* path, int64_t size, int option) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteFile(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCreateDirectory(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteDirectory(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoDeleteDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCleanDirectoryRecursively(const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRenameFile(const char* currentPath, const char* newPath) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoRenameDirectory(const char* currentPath, const char* newPath) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetEntryType(DirectoryEntryType* outValue, const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetFreeSpaceSize(int64_t* outValue, const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetTotalSpaceSize(int64_t* outValue, const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoOpenFile(std::unique_ptr<fsa::IFile>* outValue, const char* path, OpenMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoOpenDirectory(std::unique_ptr<fsa::IDirectory>* outValue, const char* path, OpenDirectoryMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoCommit() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoGetFileTimeStampRaw(FileTimeStampRaw* outTimeStamp, const char* path) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result DoQueryEntry(char* outBuffer, size_t outBufferSize, const char* inBuffer, size_t inBufferSize, fs::fsa::QueryId queryId, const char* path) NN_NOEXCEPT NN_OVERRIDE;

        nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem> GetFileSystem() const NN_NOEXCEPT
        {
            return m_fileSystemServiceObject;
        }

    private:
        nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem> m_fileSystemServiceObject;
    };
}}}
