﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/fs/detail/fs_MemoryManagementPrivate.h>

namespace nn { namespace fs {

    template <class T>
    class Allocator : public std::allocator<T>
    {
    public:
        template<class U>
        struct rebind
        {
            typedef Allocator<U> other;
        };

    public:
        Allocator() NN_NOEXCEPT
            : m_IsAllocationFailed(false)
        {
        }

        NN_IMPLICIT Allocator(const Allocator& other) NN_NOEXCEPT
            : m_IsAllocationFailed(other.IsAllocationFailed())
        {
        }

        template<class U>
        Allocator(const Allocator<U>& other) NN_NOEXCEPT
            : m_IsAllocationFailed(other.IsAllocationFailed())
        {
        }

    public:
        typename std::allocator<T>::pointer allocate(typename std::allocator<T>::size_type size, typename std::allocator<T>::const_pointer hint = 0) NN_NOEXCEPT
        {
            NN_UNUSED(hint);
            auto* pAllocated = reinterpret_cast<typename std::allocator<T>::pointer>(detail::Allocate(sizeof(T) * size));
            if( pAllocated == nullptr && size > 0 )
            {
                SetAllocationFailed(true);
            }
            return pAllocated;
        }

        void deallocate(typename std::allocator<T>::pointer p, typename std::allocator<T>::size_type size) NN_NOEXCEPT
        {
            detail::Deallocate(p, sizeof(T) * size);
        }

        template <class U, class... Args>
        void construct(U* p, Args&&... args) NN_NOEXCEPT
        {
            if( !IsAllocationFailed() )
            {
                ::new(reinterpret_cast<void*>(p)) U(std::forward<Args>(args)...);
            }
        }

        bool IsAllocationFailed() const NN_NOEXCEPT
        {
            return m_IsAllocationFailed;
        }

    protected:
        void SetAllocationFailed(bool isAllocationFailed) NN_NOEXCEPT
        {
            m_IsAllocationFailed = isAllocationFailed;
        }

    private:
        bool m_IsAllocationFailed;
    };

}}
