﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Result.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/eth/eth_EthTypes.h>
#include <nn/eth/eth_Result.h>

namespace nn     {
namespace eth    {
namespace server {

class InterfaceSfObject;

class Interface :
    public nn::util::IntrusiveListBaseNode<Interface>
{

private:
    nn::util::IntrusiveList<InterfaceSfObject, nn::util::IntrusiveListBaseNodeTraits<InterfaceSfObject>> m_ClientList;
    nn::os::Mutex m_ClientListLock;

public:
    Interface()  NN_NOEXCEPT;
    ~Interface() NN_NOEXCEPT;

    virtual nn::Result GetInterfaceInfo(InterfaceInfo* pInfo)
    NN_NOEXCEPT
    {
        return nn::eth::ResultNotSupported();
    }

    virtual nn::Result GetMediaList(MediaList* mediaOut)
    NN_NOEXCEPT
    {
        return nn::eth::ResultNotSupported();
    }

    virtual nn::Result SetMediaType(MediaType mediaType)
    NN_NOEXCEPT
    {
        return nn::eth::ResultNotSupported();
    }

    virtual nn::Result GetMediaType(MediaType* mediaRequestedOut, MediaType* mediaCurrentOut, uint32_t* eventCounter)
    NN_NOEXCEPT
    {
        return nn::eth::ResultNotSupported();
    }

    virtual const char* DeviceName()
    NN_NOEXCEPT
    {
        return "unknown";
    }

    void       AttachClient(InterfaceSfObject* client) NN_NOEXCEPT;
    void       DetachClient(InterfaceSfObject* client) NN_NOEXCEPT;
    void       Signal(nn::Result result) NN_NOEXCEPT;
    nn::Result Initialize() NN_NOEXCEPT;
    nn::Result Finalize() NN_NOEXCEPT;
};

// collect information about all attached and configured interfaces
nn::Result ListInterfaces(InterfaceList* pInterfaceListOut) NN_NOEXCEPT;

// total count of attached interfaces, both configured and non-configured
nn::Result InterfaceCount(uint32_t* interfaceCountOut) NN_NOEXCEPT;

// attach client to interface
nn::Result AttachToInterface(Interface** pInterfaceOut, const char* nameIn, InterfaceSfObject* clientIn) NN_NOEXCEPT;

// signal adapter insertion or removal
void       SignalGroup(nn::Result result) NN_NOEXCEPT;

}}}
