﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*-
 * Copyright (c) 1997, 1998, 1999, 2000-2003
 *      Bill Paul <wpaul@windriver.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Bill Paul.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Bill Paul AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bill Paul OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#pragma once

namespace nn     {
namespace eth    {
namespace device {
namespace usb    {

#define AXE_CMD_IS_WRITE(x)     (((x) & 0x0F00) >> 8)
#define AXE_CMD_LEN(x)          (((x) & 0xF000) >> 12)
#define AXE_CMD_CMD(x)          ((x) & 0x00FF)

enum
{
    AXE_CMD_MII_OPMODE_SW       = 0x0106,
    AXE_CMD_MII_READ_REG        = 0x2007,
    AXE_CMD_MII_WRITE_REG       = 0x2108,
    AXE_CMD_MII_READ_OPMODE     = 0x1009,
    AXE_CMD_MII_OPMODE_HW       = 0x010A,
    AXE_CMD_SROM_READ           = 0x200B,
    AXE_CMD_SROM_WRITE          = 0x010C,
    AXE_CMD_SROM_WR_ENABLE      = 0x010D,
    AXE_CMD_SROM_WR_DISABLE     = 0x010E,
    AXE_CMD_RXCTL_READ          = 0x200F,
    AXE_CMD_RXCTL_WRITE         = 0x0110,
    AXE_CMD_READ_IPG012         = 0x3011,
    AXE_CMD_WRITE_IPG012        = 0x0112,
    AXE_CMD_READ_NODEID         = 0x6013,
    AXE_CMD_WRITE_NODEID        = 0x6114,
    AXE_CMD_READ_MCAST          = 0x8015,
    AXE_CMD_WRITE_MCAST         = 0x8116,
    AXE_CMD_READ_PHYID          = 0x2019,
    AXE_CMD_READ_MEDIA          = 0x201A,
    AXE_CMD_WRITE_MEDIA         = 0x011B,
    AXE_CMD_READ_MONITOR_MODE   = 0x101C,
    AXE_CMD_WRITE_MONITOR_MODE  = 0x011D,
    AXE_CMD_READ_GPIO           = 0x101E,
    AXE_CMD_WRITE_GPIO          = 0x011F,
    AXE_CMD_SW_RESET_REG        = 0x0120,
    AXE_CMD_SW_PHY_STATUS       = 0x0021,
    AXE_CMD_SW_PHY_SELECT       = 0x0122,
};

enum
{
    AXE_SW_RESET_CLEAR          = 0x00,
    AXE_SW_RESET_RR             = 0x01,
    AXE_SW_RESET_RT             = 0x02,
    AXE_SW_RESET_PRTE           = 0x04,
    AXE_SW_RESET_PRL            = 0x08,
    AXE_SW_RESET_BZ             = 0x10,
    AXE_SW_RESET_IPRL           = 0x20,
    AXE_SW_RESET_IPPD           = 0x40,
};

enum
{
    AXE_MEDIA_GMII              = 0x0001,
    AXE_MEDIA_FULL_DUPLEX       = 0x0002,
    /* AX88178/88772 documentation says to always write 1 to bit 2 */
    AXE_MEDIA_MAGIC             = 0x0004,
    /* AX88772 documentation says to always write 0 to bit 3 */
    AXE_MEDIA_ENCK              = 0x0008,
    AXE_MEDIA_RXFLOW_CONTROL_EN = 0x0010,
    AXE_MEDIA_TXFLOW_CONTROL_EN = 0x0020,
    AXE_MEDIA_RX_EN             = 0x0100,
    AXE_MEDIA_100TX             = 0x0200,
    AXE_MEDIA_SUPERMAC          = 0x1000,
};

enum
{
    AXE_RXCMD_PROMISC           = 0x0001,
    AXE_RXCMD_ALLMULTI          = 0x0002,
    AXE_RXCMD_BROADCAST         = 0x0008,
    AXE_RXCMD_MULTICAST         = 0x0010,
    AXE_RXCMD_ENABLE            = 0x0080,
    AXE_RXCMD_MFB_MASK          = 0x0300,
    AXE_RXCMD_MFB_2048          = 0x0000,
    AXE_RXCMD_MFB_4096          = 0x0100,
    AXE_RXCMD_MFB_8192          = 0x0200,
    AXE_RXCMD_MFB_16384         = 0x0300
};

enum
{
    AXE_PHY_SEL_PRI             = 1,
    AXE_PHY_SEL_SEC             = 0,
};

enum
{
    AXE_GPIO0_EN                = 0x01,
    AXE_GPIO0                   = 0x02,
    AXE_GPIO1_EN                = 0x04,
    AXE_GPIO1                   = 0x08,
    AXE_GPIO2_EN                = 0x10,
    AXE_GPIO2                   = 0x20,
    AXE_GPIO_RELOAD_EEPROM      = 0x80
};

enum
{
    AXE_BULK_BUF_SIZE           = 16384    /* bytes */
};

enum
{
    AX_INT_PPLS_LINK     = (1 << 0),
    AX_INT_SPLS_LINK     = (1 << 1),
    AX_INT_CABOFF_UNPLUG = (1 << 7),
};

// Describes each frame on bulkin/bulkout endpoint
struct PacketHeader
{
    uint16_t    packetLength;
    uint16_t    ipacketLength;
}
__attribute__((packed));

// Returned on interrupt end point
struct LinkState
{
    uint16_t    res1;
    uint8_t     link;
    uint16_t    res2;
    uint8_t     status;
    uint16_t    res3;
} __attribute__((packed));


}}}}
