﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/dd.h>
#include <nn/os/os_InterruptEvent.h>

namespace nn     {
namespace eth    {
namespace device {
namespace tx2    {
namespace pcv    {

// ------------------------------------------------------------------------------------------------
// Address map

const nn::dd::PhysicalAddress GpioCtl0Gpio5PhysAddr = 0x02215000;
const size_t GpioCtl0Gpio5Size = 0x1000;

const size_t GpioOffset_EqosReset = 0x690; // M4: EQOS Reset

const nn::dd::PhysicalAddress HspDbPhysAddr = 0x03c90000;
const size_t HspDbSize = 0x10000;

const size_t HspDbOffset_Bpmp = 0x300;

const nn::dd::PhysicalAddress SysramPhysAddr = 0x30000000;
const size_t SysramSize = 0x50000;

// ------------------------------------------------------------------------------------------------
// BPMP call

// Sysram adress
const size_t SysramOffset_BpmpTxWriteCount  = 0x4e000; // CPU->BPMP write count (owner: CPU)
const size_t SysramOffset_BpmpTxReadCount   = 0x4e040; // CPU->BPMP read count (owner: BPMP)
const size_t SysramOffset_BpmpTxRequest     = 0x4e080; // CPU->BPMP mrq_request (owner: CPU)
const size_t SysramOffset_BpmpRxWriteCount  = 0x4f000; // BPMP->CPU write count (owner: BPMP)
const size_t SysramOffset_BpmpRxReadCount   = 0x4f040; // BPMP->CPU read count (owner: CPU)
const size_t SysramOffset_BpmpRxResponse    = 0x4f080; // BPMP->CPU mrq_response (owner: BPMP)

// MRQ header
enum MrqType : uint32_t
{
    MrqType_Reset = 0x14,
    MrqType_Clock = 0x16,
};

enum MrqFlag : uint32_t
{
    MrqFlag_BpmpFlagDoAck           = 0x01,
    MrqFlag_BpmpFlagRingDoorbell    = 0x02,
};

struct MrqRequestHeader
{
    MrqType type;
    uint32_t flags;
};

struct MrqResponseHeader
{
    int32_t error;
    uint32_t flags;
};

// MRQ clock
enum MrqClockCommandType : uint32_t
{
    MrqClockCommandType_SetRate = 0x02,
    MrqClockCommandType_Enable  = 0x07,
};

enum MrqClockModule : uint32_t
{
    MrqClockModule_EqosMasterBus  = 0xa7,
    MrqClockModule_EqosSlaveBus   = 0x95,
    MrqClockModule_EqosRx         = 0xa8,
    MrqClockModule_EqosTx         = 0xf0,
    MrqClockModule_EqosPtpRef     = 0xef,
};

typedef uint32_t MrqClockCommand;
const int MrqClockCommand_OffsetType = 24;
const int MrqClockCommand_OffsetModule = 0;

struct MrqRequestClockEnable
{
    MrqClockCommand command;
};

struct MrqRequestClockSetRate
{
    MrqClockCommand command;
    uint32_t padding;
    ClockHz rate;
};

// MRQ reset
enum MrqResetCommand : uint32_t
{
    MrqResetCommand_Assert = 0x1,
    MrqResetCommand_Deassert = 0x2,
};

enum MrqResetModule : uint32_t
{
    MrqResetModule_Eqos = 0x45,
};

struct MrqRequestReset
{
    MrqResetCommand command;
    MrqResetModule module;
};

}}}}}
