﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.dt
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/dt/dt_Types.h>")]
    public struct Node
    {
    }
}

namespace nn.dt.detail
{
    [CppRefPath(@"<nn/dt/detail/dt_IDeviceTree.h>")]
    public interface IDeviceTree : IServiceObject
    {
        [MethodId(0)]
        Result FindNodeByPath(Out<nn.dt.Node> outNode, nn.sf.InBuffer path);

        [MethodId(1)]
        Result FindNodeByPHandle(Out<nn.dt.Node> outNode, uint32_t phandle);

        [MethodId(2)]
        Result GetCompatibleNodeCount(Out<uint64_t> outCount, nn.sf.InBuffer compatible);

        [MethodId(3)]
        Result ListCompatibleNode(nn.sf.OutBuffer outNodeList, Out<uint64_t> outCount, uint64_t maxCount, nn.sf.InBuffer compatible);

        [MethodId(4)]
        Result GetParentNode(Out<nn.dt.Node> outNode, nn.dt.Node currentNode);

        [MethodId(5)]
        Result GetChildNodeByName(Out<nn.dt.Node> outNode, nn.dt.Node currentNode, nn.sf.InBuffer name);

        [MethodId(6)]
        Result GetChildNodeCount(Out<uint64_t> outCount, nn.dt.Node currentNode);

        [MethodId(7)]
        Result ListChildNode(nn.sf.OutBuffer outNodeList, Out<uint64_t> outCount, uint64_t maxCount, nn.dt.Node currentNode);

        [MethodId(8)]
        Result GetValueOfAddressCells(Out<uint32_t> outValue, nn.dt.Node node);

        [MethodId(9)]
        Result GetValueOfSizeCells(Out<uint32_t> outValue, nn.dt.Node node);

        [MethodId(10)]
        Result IsPropertyExist(Out<bool> outExist, nn.dt.Node node, nn.sf.InBuffer name);

        [MethodId(11)]
        Result GetPropertySize(Out<uint64_t> outSize, nn.dt.Node node, nn.sf.InBuffer name);

        [MethodId(12)]
        Result GetProperty(nn.sf.OutBuffer outValue, nn.dt.Node node, nn.sf.InBuffer name, uint64_t elementSize);

        [MethodId(13)]
        Result GetPropertyWithIndex(nn.sf.OutBuffer outValue, nn.dt.Node node, nn.sf.InBuffer name, uint64_t index, uint64_t elementSize);

        [MethodId(14)]
        Result GetPropertyList(nn.sf.OutBuffer outArray, Out<uint64_t> outPropertySize, uint64_t maxCount, nn.dt.Node node, nn.sf.InBuffer name, uint64_t elementSize);

        [MethodId(15)]
        Result GetInterruptCount(Out<uint64_t> outCount, nn.dt.Node node);

        [MethodId(16)]
        Result GetInterruptList(nn.sf.OutBuffer outList, Out<uint64_t> outActualCount, uint64_t maxCount, nn.dt.Node node);

        [MethodId(17)]
        Result GetRegisterAddressList(nn.sf.OutBuffer outList, Out<uint64_t> outActualCount, uint64_t maxCount, nn.dt.Node node, uint64_t elementSize);

        [MethodId(18)]
        Result GetRegisterSizeList(nn.sf.OutBuffer outList, Out<uint64_t> outActualCount, uint64_t maxCount, nn.dt.Node node, uint64_t elementSize);

        [MethodId(19)]
        Result GetFirstChildNode(Out<nn.dt.Node> outNode, nn.dt.Node currentNode);

        [MethodId(20)]
        Result GetNextSiblingNode(Out<nn.dt.Node> outNode, nn.dt.Node currentNode);

        [MethodId(21)]
        Result GetNodePath(nn.sf.OutBuffer outPath, nn.dt.Node node);

        [MethodId(22)]
        Result DumpNode(nn.dt.Node node, int depth);
    }
}
