﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/svc/svc_Base.h>

#include "dt_FdtStorage.h"

namespace nn { namespace dt { namespace server {

namespace {
    // Device Tree をマップする領域のサイズ
    const size_t FdtStorageSize = 0x200000; // 2MB
}

const nn::Bit8* GetFdtStoragePointer()
{
    uintptr_t v = 0;
    do
    {
        nn::svc::MemoryInfo blockInfo;
        nn::svc::PageInfo pageInfo;
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::svc::QueryMemory(&blockInfo, &pageInfo, v));
        if (blockInfo.state == nn::svc::MemoryState_Static && blockInfo.size == FdtStorageSize)
        {
            return reinterpret_cast<const nn::Bit8*>(blockInfo.baseAddress);
        }

        v = blockInfo.baseAddress + blockInfo.size;
    } while (v);

    return nullptr;
}

size_t GetFdtStorageSize()
{
    return FdtStorageSize;
}

}}}
