﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/dt/dt_Types.h>

namespace nn { namespace dt { namespace server {

/*
* @brief ログ出力のインデントサイズ
*/
const int IndentSize = 8;

/*
* @brief
*   interrupts プロパティの各割り込みに関する情報をパースして、
*   InterruptInfo を取得します。
*/
nn::Result GetInterruptInfo(InterruptInfo* pOutInfo, const uint32_t* pCells, size_t cellCount);

/*
* @brief
*   プロパティの内容をログ出力します。
*   depth にはノード探索の深さを指定し、負の値の場合はリーフまで探索を行います。
*/
void PrintNode(const void* pFdt, Node* pNode, int depth) NN_NOEXCEPT;

}}}
