﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//#include <cstddef>

#include <nnc/nn_Common.h>
#include <nnc/result/result_CConverter.h>

#include <nnc/dt.h>
#include <nn/nn_StaticAssert.h>
#include <nn/dt/dt_Types.h>
#include <nn/dt/dt_InterruptApi.h>
#include <nn/dt/dt_NodeApi.h>
#include <nn/dt/dt_PropertyApi.h>
#include <nn/dt/dt_RegisterApi.h>

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメント、定数値等が一致しているのかをチェック
//---------------------------------------------------------------------------

NN_STATIC_ASSERT(sizeof(nndtPHandle) == sizeof(nn::dt::PHandle));
NN_STATIC_ASSERT(NN_ALIGNOF(nndtPHandle) == NN_ALIGNOF(nn::dt::PHandle));

NN_STATIC_ASSERT(nndtMaxNodeNameLength == nn::dt::MaxNodeNameLength);
NN_STATIC_ASSERT(nndtMaxPropertyNameLength == nn::dt::MaxPropertyNameLength);

NN_STATIC_ASSERT(sizeof(nndtNode) == sizeof(nn::dt::Node));
NN_STATIC_ASSERT(NN_ALIGNOF(nndtNode) == NN_ALIGNOF(nn::dt::Node));

NN_STATIC_ASSERT(sizeof(nndtInterruptTriggerType) == sizeof(nn::dt::InterruptTriggerType));
NN_STATIC_ASSERT(NN_ALIGNOF(nndtInterruptTriggerType) == NN_ALIGNOF(nn::dt::InterruptTriggerType));
NN_STATIC_ASSERT(static_cast<int>(nndtInterruptTriggerType_Unspecified) == static_cast<int>(nn::dt::InterruptTriggerType_Unspecified));
NN_STATIC_ASSERT(static_cast<int>(nndtInterruptTriggerType_Edge) == static_cast<int>(nn::dt::InterruptTriggerType_Edge));
NN_STATIC_ASSERT(static_cast<int>(nndtInterruptTriggerType_Level) == static_cast<int>(nn::dt::InterruptTriggerType_Level));

NN_STATIC_ASSERT(sizeof(nndtInterruptPolarityType) == sizeof(nn::dt::InterruptPolarityType));
NN_STATIC_ASSERT(NN_ALIGNOF(nndtInterruptPolarityType) == NN_ALIGNOF(nn::dt::InterruptPolarityType));
NN_STATIC_ASSERT(static_cast<int>(nndtInterruptPolarityType_Unspecified) == static_cast<int>(nn::dt::InterruptPolarityType_Unspecified));
NN_STATIC_ASSERT(static_cast<int>(nndtInterruptPolarityType_ActiveHigh) == static_cast<int>(nn::dt::InterruptPolarityType_ActiveHigh));
NN_STATIC_ASSERT(static_cast<int>(nndtInterruptPolarityType_ActiveLow) == static_cast<int>(nn::dt::InterruptPolarityType_ActiveLow));

NN_STATIC_ASSERT(sizeof(nndtInterruptInfo) == sizeof(nn::dt::InterruptInfo));
NN_STATIC_ASSERT(NN_ALIGNOF(nndtInterruptInfo) == NN_ALIGNOF(nn::dt::InterruptInfo));
NN_STATIC_ASSERT(offsetof(nndtInterruptInfo, name) == offsetof(nn::dt::InterruptInfo, name));
NN_STATIC_ASSERT(offsetof(nndtInterruptInfo, trigger) == offsetof(nn::dt::InterruptInfo, trigger));
NN_STATIC_ASSERT(offsetof(nndtInterruptInfo, polarity) == offsetof(nn::dt::InterruptInfo, polarity));
