﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dmnt0/dmnt0_Api.h>
#include <nn/dmnt0/detail/dmnt0_Interface.h>

#include <nn/svc/svc_Handle.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn { namespace dmnt0 {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::dmnt0::detail::IInterface> g_RefInterface;
        bool g_IsInitialized = false;
    }

    Result Initialize() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<nn::dmnt0::detail::IInterface, MyAllocator::Policy>(
            &g_RefInterface, nn::dmnt0::detail::PortName);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result Finalize() NN_NOEXCEPT
    {
        NN_ABORT("not implemented");
        return ResultSuccess();
    }

    Result DebugNewProcess(nn::svc::Handle* pOut, nn::os::ProcessId* pId, ncm::ProgramId programId, int port) NN_NOEXCEPT
    {
        return g_RefInterface->DebugNewProcess(reinterpret_cast<nn::sf::NativeHandle*>(pOut), pId, programId, port);
    }

    Result AttachProcess(nn::svc::Handle* pOut, nn::os::ProcessId processId, int port) NN_NOEXCEPT
    {
        return g_RefInterface->AttachProcess(reinterpret_cast<nn::sf::NativeHandle*>(pOut), processId, port);
    }

}}
