﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace diag {

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
namespace detail {
    bool IsSystemSymbolImpl(uintptr_t address) NN_NOEXCEPT;
}

bool IsSystemSymbol(uintptr_t address) NN_NOEXCEPT
{
    return detail::IsSystemSymbolImpl(address);
}
#endif

namespace detail {
    uintptr_t GetSymbolNameImpl(char* outNameBuffer, size_t nameBufferSize, uintptr_t address) NN_NOEXCEPT;
    size_t GetSymbolSizeImpl(uintptr_t address) NN_NOEXCEPT;
}

uintptr_t GetSymbolName(char* outNameBuffer, size_t nameBufferSize, uintptr_t address) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outNameBuffer);
    NN_SDK_REQUIRES_GREATER(nameBufferSize, 0u);
    NN_SDK_REQUIRES_GREATER(address, 0u);

    return detail::GetSymbolNameImpl(outNameBuffer, nameBufferSize, address);
}

size_t GetSymbolSize(uintptr_t address) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_GREATER(address, 0u);

    return detail::GetSymbolSizeImpl(address);
}

}} // nn::diag
