﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/diag/diag_Module.h>

namespace nn { namespace diag { namespace detail {
    uintptr_t GetModulePathImpl(char* outPathBuffer, size_t pathBufferSize, uintptr_t address) NN_NOEXCEPT;
    int GetAllModuleInfoImpl(size_t* outRequiredBufferSize, void* outBuffer, size_t bufferSize, bool skipSave) NN_NOEXCEPT;
    bool GetReadOnlyDataSectionRangeImpl(uintptr_t* outStartAddress, uintptr_t* outEndAddress, uintptr_t baseAddress) NN_NOEXCEPT;
}

uintptr_t GetModulePath(char* outPathBuffer, size_t pathBufferSize, uintptr_t address) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outPathBuffer);
    NN_SDK_REQUIRES_GREATER(address, 0u);
    NN_SDK_REQUIRES_GREATER(pathBufferSize, 0u);

    return detail::GetModulePathImpl(outPathBuffer, pathBufferSize, address);
}

int GetAllModuleInfo(ModuleInfo** pOutModules, void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutModules);
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES_GREATER(bufferSize, 0u);

    size_t requiredBufferSize;
    *pOutModules = reinterpret_cast<nn::diag::ModuleInfo*>(buffer);
    return detail::GetAllModuleInfoImpl(&requiredBufferSize, buffer, bufferSize, false);
}

size_t GetRequiredBufferSizeForGetAllModuleInfo() NN_NOEXCEPT
{
    size_t requiredBufferSize;
    if (detail::GetAllModuleInfoImpl(&requiredBufferSize, nullptr, 0u, true) == 0)
    {
        return 0;
    }
    return requiredBufferSize;
}

bool GetReadOnlyDataSectionRange(uintptr_t* outStartAddress, uintptr_t* outEndAddress, uintptr_t baseAddress) NN_NOEXCEPT
{
    return detail::GetReadOnlyDataSectionRangeImpl(outStartAddress, outEndAddress, baseAddress);
}

}} // nn::diag
