﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/diag_Debugger.h>
#include <nn/nn_Abort.h>
#include <nn/svc/svc_Base.h>

namespace nn { namespace diag {

bool IsDebuggerAttached() NN_NOEXCEPT
{
    nn::Bit64 info;

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::svc::GetInfo(&info, nn::svc::InfoType_DebuggerPresence, nn::svc::Handle(0), 0));

    return static_cast<bool>(info);
}

}} // nn::diag
