﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/diag_Backtrace.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace diag {

namespace detail {
    int GetBacktraceImpl(uintptr_t *pOutArray, int arrayCountMax) NN_NOEXCEPT;
}

int GetBacktrace(uintptr_t *pOutArray, int arrayCountMax) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutArray);
    NN_SDK_REQUIRES_GREATER(arrayCountMax, 0);

    return detail::GetBacktraceImpl(pOutArray, arrayCountMax);
}

// 互換性のために残してあります。
size_t GetBacktrace(uintptr_t *pOutArray, size_t arrayCountMax) NN_NOEXCEPT
{
    return static_cast<size_t>(GetBacktrace(pOutArray, static_cast<int>(arrayCountMax)));
}

}} // nn::diag
