﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/svc/svc_Base.h>
#include <nn/diag/diag_AbortTypes.h>
#include <nn/diag/diag_AbortObserver.h>
#include "diag_AbortObserverManager.h"

namespace nn { namespace diag { namespace detail {

void DefaultAbortObserver(const AbortInfo &abortInfo) NN_NOEXCEPT;

NN_NORETURN void Abort(const Result* result) NN_NOEXCEPT
{
    nn::svc::Break(nn::svc::BreakReason_Panic, reinterpret_cast<uintptr_t>(result), sizeof(Result));
    while(NN_STATIC_CONDITION(true))
    {
    }
}

extern bool g_EnableDefaultAbortObserver;

void InvokeAbortObserver(
    const AbortInfo& abortInfo) NN_NOEXCEPT
{
    if (g_EnableDefaultAbortObserver)
    {
        DefaultAbortObserver(abortInfo);
    }
    GetAbortObserverManager()->InvokeAllObserver(abortInfo);
}

void InvokeSdkAbortObserver(
    const SdkAbortInfo& abortInfo) NN_NOEXCEPT
{
    GetSdkAbortObserverManager()->InvokeAllObserver(abortInfo);
}

}}} // nn::diag::detail
