﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_Common.h>
#include <nn/diag/diag_AbortTypes.h>

namespace nn { namespace diag { namespace detail {

void DefaultAbortObserver(const AbortInfo &abortInfo) NN_NOEXCEPT;

NN_NORETURN void Abort(const Result* result) NN_NOEXCEPT
{
    NN_UNUSED(result);

    std::abort();
    while(NN_STATIC_CONDITION(true))
    {
    }
}

void InvokeAbortObserver(
    const AbortInfo& abortInfo) NN_NOEXCEPT
{
    DefaultAbortObserver(abortInfo);
}

}}} // nn::diag::detail
