﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/dd/dd_Cache.h>
#include <nn/dd/dd_Result.h>

#include "detail/dd_CacheImpl.h"

namespace nn { namespace dd {

void InvalidateDataCache( void* addr, size_t size ) NN_NOEXCEPT
{
    detail::InvalidateDataCacheImpl( addr, size );
}

void StoreDataCache( const void* addr, size_t size ) NN_NOEXCEPT
{
    detail::StoreDataCacheImpl( addr, size );
}

void FlushDataCache( const void* addr, size_t size ) NN_NOEXCEPT
{
    detail::FlushDataCacheImpl( addr, size );
}

Result InvalidateProcessDataCache( ProcessHandle handle, uint64_t addr, uint64_t size ) NN_NOEXCEPT
{
    return detail::InvalidateProcessDataCacheImpl( handle, addr, size );
}

Result StoreProcessDataCache( ProcessHandle handle, uint64_t addr, uint64_t size ) NN_NOEXCEPT
{
    return detail::StoreProcessDataCacheImpl( handle, addr, size );
}

Result FlushProcessDataCache( ProcessHandle handle, uint64_t addr, uint64_t size ) NN_NOEXCEPT
{
    return detail::FlushProcessDataCacheImpl( handle, addr, size );
}

}}  // namespace nn::dd
