﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief Packet Manager
 *
 * @details
 */

namespace nn { namespace bsdsocket { namespace dhcpc {

class Interface;

class PacketManager
{
public:
    struct DhcpPacket
    {
        nn::socket::Ip      ip;
        nn::socket::UdpHdr  udp;
        DhcpMessage         dhcp;
    }__packed __aligned(4);

    enum
    {
        RawFlags_EOF         = 1 << 0,
        RawFlags_PartialCsum = 1 << 1,
    }RawFlags;

    PacketManager();
    ~PacketManager();


    Result Initialize(Interface *pInterface);
    Result Finalize();
    Result SendRawPacket(nn::socket::EtherType protocol, const void *data, size_t len);
    ssize_t ReadRawPacket(nn::socket::EtherType protocol, void *data, size_t len, int *flags);
    Result SendUdpPacket(const nn::socket::InAddr *destAddr,const nn::socket::InAddr *sourceAddr, const void *data, size_t len);
    void ClearRawReceiveBuffer(nn::socket::EtherType protocol);
    int GetRawFd();
    int ValidateUdpPacket(const uint8_t *data, size_t data_len, nn::socket::InAddr *from, int noudpcsum);
    static size_t MakeUdpPacket(DhcpPacket *pPkt, size_t dhcpMessageSize,
                                const nn::socket::InAddr *source, const nn::socket::InAddr *dest);


private:
    static const size_t ETHER_HEADER_SIZE = (nn::socket::Ether_Addr_Len * 2 + sizeof(uint16_t));
    static const int BPF_FILTER_ENTRIES = 11;
    static const nn::socket::BpfInsn m_BpfFilter[BPF_FILTER_ENTRIES];

    int32_t DecodeUdpIpHeader(uint8_t *buf, size_t bufix,
                              struct sockaddr_in *from, size_t buflen,
                              size_t *rbuflen, int csum_ready);

    Interface   *m_pInterface;
    int         m_RawFd;
    int         m_ArpFd;
    size_t      m_Biocgblen;

    // Receive buffer
    struct
    {
        int32_t length;
        int32_t position;
        uint8_t data[1024 * 4];
    }m_ReadBuffer;
};

} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn

