﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "dhcpc_PrivateIncludes.h"

namespace nn { namespace bsdsocket { namespace dhcpc {

static DhcpcMain dhcpc;

Result Initialize()
{
    return dhcpc.Initialize();
}

Result Finalize()
{
    return dhcpc.Finalize();
}

Result InitializeClient(int32_t ifIndex,
                        const InterfaceConfigType *pIfConfig)
{
    return dhcpc.InitializeClientInterface(ifIndex, pIfConfig);
}

Result FinalizeClient(int32_t ifIndex,uint32_t options)
{
    return dhcpc.FinalizeClientInterface(ifIndex,options);
}

Result GetOptionData(int32_t ifIndex, DhcpProtOption option,
                     void *pRetData, size_t bufferSize, size_t *pRetSize)
{
    return dhcpc.GetOptionData(ifIndex, option, pRetData, bufferSize, pRetSize);
}

Result GetState(int32_t ifIndex, char *pReturnedStateName, size_t stateNameSizeLimit)
{
    return dhcpc.GetState(ifIndex, pReturnedStateName, stateNameSizeLimit);
}

Result ForceRenew(int32_t ifIndex)
{
    return dhcpc.ForceRenew(ifIndex);
}

} // namespace dhcpc
} // namespace bsdsocket
} // namespace nn




