﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief BSD Configuration
 *
 * @details Top level BSD configuration management
 */

#pragma once

namespace nn { namespace bsdsocket { namespace cfg {

class Server : public nn::sf::HipcSimpleAllInOneServerManager<2, 1>
{
public:
    Server()
    : m_DefaultIfIndex(-1)
    , m_AccessMutex(true)
    {
        memset(m_IfTable, 0, sizeof(m_IfTable));
    }
    ~Server()
    {

    }

    Result Initialize();
    Result Finalize();
    Result SetIfUp(const nn::sf::InBuffer &ifName, IfSettings ifOptionData);
    Result SetIfUpWithEvent(const nn::sf::InBuffer &ifName, IfSettings ifOptionData, nn::sf::Out<nn::sf::NativeHandle> handleOut);
    Result CancelIf(const nn::sf::InBuffer &ifName);
    Result SetIfDown(const nn::sf::InBuffer &ifName, uint32_t options);
    Result GetIfState(const nn::sf::InBuffer &ifName, nn::sf::OutBuffer ifState);
    Result DhcpRenew(const nn::sf::InBuffer &ifName);
    Result AddStaticArpEntry(uint32_t ipAddress, const nn::sf::InBuffer &inputHardwareAddress);
    Result RemoveArpEntry(uint32_t ipAddress);
    Result LookupArpEntry(nn::sf::OutBuffer outputHardwareAddress, uint32_t ipAddress);
    Result LookupArpEntry2(nn::sf::OutBuffer outputIpAddress,const nn::sf::InBuffer &hardwareAddress);
    Result ClearArpEntries();
    Result ClearArpEntries2(const nn::sf::InBuffer &ifName);
    Result PrintArpEntries();

private:
    struct ManagedIf
    {
        bool            allocated;
        int32_t         ifIndex;
        char            name[Limits_MaxIfNameSize];
        Interface       i;
    };

    ManagedIf* GetMif(const char *name);
    ManagedIf* AllocMif(const char *ifName);
    void FreeMif(ManagedIf *);
    void SessionThreadEntry();
    static void SessionThreadEntryStatic(void *pThis) { ((Server *)pThis)->SessionThreadEntry();}

    int32_t        m_DefaultIfIndex;
    nn::os::Mutex  m_AccessMutex;
    ManagedIf      m_IfTable[Limits_MaxInterfaces];
    NetworkThread  m_Threads[Limits_MaxSessionThreads];
#ifdef NN_SDK_BUILD_DEBUG
    NN_ALIGNAS(nn::os::StackRegionAlignment) uint8_t m_ThreadStacks[Limits_MaxSessionThreads][1024 * 32];
#else
    NN_ALIGNAS(nn::os::StackRegionAlignment) uint8_t m_ThreadStacks[Limits_MaxSessionThreads][1024 * 16];
#endif
};

} // namespace cfg
} // namespace bsdsocket
} // namespace nn

