﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief List of include files used internally
 *
 * @details Centralized management of all private includes
 */

#pragma once

#include <cstdio>
#include <cstring>
#include <type_traits>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_StringUtil.h>
#include <nn/dd.h>
#include <nn/os.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_TickApi.h>
#include <nn/os/os_TimerEvent.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>

#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_ApiPrivate.h>
#include <nn/socket/private/thread.h>

#include <nn/bsdsocket/bsdsocket_Result.private.h>
#include <nn/socket/resolver/resolver_Server.h>
#include <nn/bsdsocket/dhcpc/dhcpc.h>
#include <nn/bsdsocket/cfg/cfg.h>
#include <nn/bsdsocket/cfg/sfdl/cfg.sfdl.h>

#include "cfg_Arp.h"
#include "cfg_Macros.h"
#include "cfg_Interface.h"
#include "cfg_Server.h"
#include "cfg_Ipv4.h"
#include "cfg_DumpRoute.h"
